/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.CompositeCost;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.t.ThreeDogGalaxyNewsDJTokenEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.AttachedToSourcePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ThreeDogGalaxyNewsDJEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.AURA, "Aura attached to this creature");

    ThreeDogGalaxyNewsDJEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {2} and sacrifice an Aura attached to {this}. When you sacrifice an Aura this way, for each other attacking creature you control, create a token that's a copy of that Aura attached to that creature";
    }

    private ThreeDogGalaxyNewsDJEffect(ThreeDogGalaxyNewsDJEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThreeDogGalaxyNewsDJEffect copy() {
        return new ThreeDogGalaxyNewsDJEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        SacrificeTargetCost sacCost = new SacrificeTargetCost(filter);
        CompositeCost cost = new CompositeCost((Cost)new GenericManaCost(2), (Cost)sacCost, "Pay {2} and sacrifice an Aura attached to this creature");
        if (!(cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(this.outcome, "Pay {2} and sacrifice an Aura?", source, game) && cost.pay(source, game, source, source.getControllerId(), false))) {
            return false;
        }
        Permanent permanent = sacCost.getPermanents().stream().findFirst().orElse(null);
        game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new ThreeDogGalaxyNewsDJTokenEffect(permanent), false), source);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AttachedToSourcePredicate.instance);
    }
}

