/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.ManaType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.ChosenSubtypePredicate;
import mage.game.Game;
import mage.players.Player;

class ThreeTreeCityManaEffect
extends ManaEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("Creatures you control of the chosen type");

    ThreeTreeCityManaEffect() {
        this.staticText = "Choose a color. Add an amount of mana of that color equal to the number of creatures you control of the chosen type";
    }

    private ThreeTreeCityManaEffect(ThreeTreeCityManaEffect effect) {
        super((ManaEffect)effect);
    }

    public ThreeTreeCityManaEffect copy() {
        return new ThreeTreeCityManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        if (game == null || !game.inCheckPlayableState()) {
            return new ArrayList<Mana>();
        }
        int count = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (count > 0) {
            netMana.add(Mana.AnyMana((int)count));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        if (game == null) {
            return null;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return null;
        }
        int creatures = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game);
        if (creatures == 0) {
            return null;
        }
        ChoiceColor choice = new ChoiceColor();
        choice.setMessage("Choose the color of mana to add");
        if (!controller.choose(this.outcome, (Choice)choice, game)) {
            return null;
        }
        ManaType chosenType = ManaType.findByName((String)choice.getChoice());
        return chosenType == null ? null : new Mana(chosenType, creatures);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)ChosenSubtypePredicate.TRUE);
    }
}

