/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.t.ThreeWishesPlayFromExileEffect;
import mage.cards.t.ThreeWishesPutIntoGraveyardEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ThreeWishesExileEffect
extends OneShotEffect {
    ThreeWishesExileEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Exile the top three cards of your library face down. Until your next turn, you may play those cards. At the beginning of your next upkeep, put any of those cards you didn't play into your graveyard";
    }

    private ThreeWishesExileEffect(ThreeWishesExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)0);
            Set topThreeCards = controller.getLibrary().getTopCards(game, 3);
            for (Card card : topThreeCards) {
                if (!controller.moveCardsToExile(card, source, game, true, exileId, "Three Wishes")) continue;
                card.setFaceDown(true, game);
                ThreeWishesPlayFromExileEffect effect = new ThreeWishesPlayFromExileEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
                game.addEffect((ContinuousEffect)effect, source);
            }
            AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility delayed = new AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility((Effect)new ThreeWishesPutIntoGraveyardEffect());
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayed, source);
            return true;
        }
        return false;
    }

    public ThreeWishesExileEffect copy() {
        return new ThreeWishesExileEffect(this);
    }
}

