/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ThreeWishesPutIntoGraveyardEffect
extends OneShotEffect {
    ThreeWishesPutIntoGraveyardEffect() {
        super(Outcome.Neutral);
        this.staticText = "At the beginning of your next upkeep, put any of those cards you didn't play into your graveyard";
    }

    private ThreeWishesPutIntoGraveyardEffect(ThreeWishesPutIntoGraveyardEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)0);
            Set cardsInExile = game.getExile().getExileZone(exileId).getCards(game);
            if (cardsInExile != null) {
                controller.moveCardsToGraveyardWithInfo(cardsInExile, source, game, Zone.EXILED);
                return true;
            }
        }
        return false;
    }

    public ThreeWishesPutIntoGraveyardEffect copy() {
        return new ThreeWishesPutIntoGraveyardEffect(this);
    }
}

