/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.PutIntoGraveFromBattlefieldThisTurnPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.CardsPutIntoGraveyardWatcher;

class ThrillingEncoreEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard();

    ThrillingEncoreEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Put onto the battlefield under your control all creature cards in all graveyards that were put there from the battlefield this turn";
    }

    private ThrillingEncoreEffect(ThrillingEncoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThrillingEncoreEffect copy() {
        return new ThrillingEncoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        CardsPutIntoGraveyardWatcher watcher = (CardsPutIntoGraveyardWatcher)game.getState().getWatcher(CardsPutIntoGraveyardWatcher.class);
        if (controller == null || watcher == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(watcher.getCardsPutIntoGraveyardFromBattlefield(game));
        cards.removeIf(uuid -> !game.getCard(uuid).isCreature(game));
        return controller.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
    }

    static {
        filter.add((Predicate)PutIntoGraveFromBattlefieldThisTurnPredicate.instance);
    }
}

