/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

class ThrunBreakerOfSilenceEffect
extends ContinuousRuleModifyingEffectImpl {
    ThrunBreakerOfSilenceEffect() {
        super(Duration.WhileOnBattlefield, Outcome.AddAbility);
        this.staticText = "{this} can't be the target of nongreen spells your opponents control or abilities from nongreen sources your opponents control";
    }

    private ThrunBreakerOfSilenceEffect(ThrunBreakerOfSilenceEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public ThrunBreakerOfSilenceEffect copy() {
        return new ThrunBreakerOfSilenceEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            return sourcePermanent.getLogName() + " can't be the target of nongreen spells you control or abilities from nongreen sources you control";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGET;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card targetCard = game.getCard(event.getTargetId());
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (targetCard != null && stackObject != null && targetCard.getId().equals(source.getSourceId()) && (stackObject instanceof Ability ? !((Ability)stackObject).getSourceObject(game).getColor(game).isGreen() : !stackObject.getColor(game).isGreen())) {
            return !stackObject.isControlledBy(source.getControllerId());
        }
        return false;
    }
}

