/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.ModifiedPredicate;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

public final class ThunderingRaiju
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();
    private static final DynamicValue xValue;
    private static final Hint hint;

    public ThunderingRaiju(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{R}{R}");
        this.subtype.add((Object)SubType.SPIRIT);
        this.power = new MageInt(3);
        this.toughness = new MageInt(3);
        this.addAbility((Ability)HasteAbility.getInstance());
        AttacksTriggeredAbility ability = new AttacksTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()));
        ability.addTarget((Target)new TargetControlledCreaturePermanent());
        ability.addEffect((Effect)new DamagePlayersEffect(Outcome.Damage, xValue, TargetController.OPPONENT).setText("Then {this} deals X damage to each opponent, where X is the number of modified creatures you control other than {this}"));
        this.addAbility(ability.addHint(hint));
    }

    private ThunderingRaiju(ThunderingRaiju card) {
        super((CardImpl)card);
    }

    public ThunderingRaiju copy() {
        return new ThunderingRaiju(this);
    }

    static {
        filter.add((Predicate)ModifiedPredicate.instance);
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        xValue = new PermanentsOnBattlefieldCount(filter);
        hint = new ValueHint("Other modified creatures you control", xValue);
    }
}

