/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TianaShipsCaretakerEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TianaShipsCaretakerTriggeredAbility
extends TriggeredAbilityImpl {
    TianaShipsCaretakerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TianaShipsCaretakerEffect(), true);
        this.setTriggerPhrase("Whenever an Aura or Equipment you control is put into a graveyard from the battlefield, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private TianaShipsCaretakerTriggeredAbility(TianaShipsCaretakerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public TianaShipsCaretakerTriggeredAbility copy() {
        return new TianaShipsCaretakerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getTarget() == null) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(zEvent.getTarget().getId());
        if (permanent != null && zEvent.isDiesEvent() && (permanent.isArtifact(game) && permanent.hasSubtype(SubType.EQUIPMENT, game) || permanent.isEnchantment(game) && permanent.hasSubtype(SubType.AURA, game)) && permanent.isControlledBy(this.controllerId)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(zEvent.getTargetId()));
            return true;
        }
        return false;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

