/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TifasLimitBreakEffect
extends OneShotEffect {
    private final int multiplier;

    TifasLimitBreakEffect(int multiplier) {
        super(Outcome.Benefit);
        this.staticText = TifasLimitBreakEffect.makeWord(multiplier) + " target creature's power and toughness until end of turn";
        this.multiplier = multiplier;
    }

    private TifasLimitBreakEffect(TifasLimitBreakEffect effect) {
        super((OneShotEffect)effect);
        this.multiplier = effect.multiplier;
    }

    public TifasLimitBreakEffect copy() {
        return new TifasLimitBreakEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        game.addEffect(new BoostTargetEffect((this.multiplier - 1) * permanent.getPower().getValue(), (this.multiplier - 1) * permanent.getToughness().getValue()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }

    private static String makeWord(int multiplier) {
        switch (multiplier) {
            case 2: {
                return "double";
            }
            case 3: {
                return "triple";
            }
        }
        throw new UnsupportedOperationException("no idea how we got here");
    }
}

