/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

class TigerTribeHunterEffect
extends OneShotEffect {
    TigerTribeHunterEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may sacrifice another creature. When you do, {this} deals damage equal to the sacrificed creature's power to target creature";
    }

    private TigerTribeHunterEffect(TigerTribeHunterEffect effect) {
        super((OneShotEffect)effect);
    }

    public TigerTribeHunterEffect copy() {
        return new TigerTribeHunterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE, true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int power = Math.max(permanent.getPower().getValue(), 0);
        if (!permanent.sacrifice(source, game)) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(power), false, "{this} deals damage equal to the sacrificed creature's power to target creature.");
        ability.addTarget((Target)new TargetCreaturePermanent());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

