/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.InvertCondition;
import mage.abilities.condition.common.CitysBlessingCondition;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.RedElementalToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class TilonallisSummonerEffect
extends OneShotEffect {
    TilonallisSummonerEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may pay {X}{R}. If you do, create X 1/1 red Elemental creature tokens that are tapped and attacking. At the beginning of the next end step, exile those tokens unless you have the city's blessing";
    }

    private TilonallisSummonerEffect(TilonallisSummonerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TilonallisSummonerEffect copy() {
        return new TilonallisSummonerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ManaCostsImpl cost = new ManaCostsImpl("{X}{R}");
            if (controller.chooseUse(this.outcome, "Pay " + cost.getText() + "? If you do, you create X 1/1 red Elemental creature tokens that are tapped and attacking.", source, game)) {
                int costX = controller.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay for tokens)", game, source, true);
                cost.add((Object)new GenericManaCost(costX));
                if (cost.pay(source, game, source, source.getControllerId(), false, null)) {
                    controller.resetStoredBookmark(game);
                    CreateTokenEffect effect = new CreateTokenEffect((Token)new RedElementalToken(), costX, true, true);
                    effect.apply(game, source);
                    OneShotEffect exileEffect = new ExileTargetEffect(null, "", Zone.BATTLEFIELD).setText("exile those tokens unless you have the city's blessing");
                    exileEffect.setTargetPointer((TargetPointer)new FixedTargets((Cards)new CardsImpl((Collection)effect.getLastAddedTokenIds()), game));
                    game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect, TargetController.ANY, (Condition)new InvertCondition((Condition)CitysBlessingCondition.instance)), source);
                }
            }
            return true;
        }
        return false;
    }
}

