/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TimeOutEffect
extends OneShotEffect {
    TimeOutEffect() {
        super(Outcome.Benefit);
        this.staticText = "Roll a six-sided die. Put target nonland permanent into its owner's library just beneath the top X cards of that library, where X is the result";
    }

    private TimeOutEffect(TimeOutEffect effect) {
        super((OneShotEffect)effect);
    }

    public TimeOutEffect copy() {
        return new TimeOutEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
            Player owner = game.getPlayer(permanent.getOwnerId());
            if (owner == null) {
                return false;
            }
            int amount = controller.rollDice(this.outcome, source, game, 6);
            controller.putCardOnTopXOfLibrary((Card)permanent, game, source, amount + 1, true);
            return true;
        }
        return false;
    }
}

