/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TimeVaultReplacementEffect
extends ReplacementEffectImpl {
    TimeVaultReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Untap);
        this.staticText = "If you would begin your turn while {this} is tapped, you may skip that turn instead. If you do, untap {this}.";
    }

    private TimeVaultReplacementEffect(TimeVaultReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TimeVaultReplacementEffect copy() {
        return new TimeVaultReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PLAY_TURN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        return source.isControlledBy(event.getPlayerId()) && (permanent = game.getPermanent(source.getSourceId())) != null && permanent.isTapped();
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player != null && permanent != null && player.chooseUse(Outcome.Untap, "Skip your turn to untap " + permanent.getName() + '?', source, game)) {
            permanent.untap(game);
            game.informPlayers(player.getLogName() + " skips their turn to untap " + permanent.getLogName());
            return true;
        }
        return false;
    }
}

