/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class TimotharBaronOfBatsReturnEffect
extends OneShotEffect {
    private final MageObjectReference morOfCardToReturn;

    TimotharBaronOfBatsReturnEffect(MageObjectReference morOfCardToReturn) {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return the exiled card to the battlefield tapped";
        this.morOfCardToReturn = morOfCardToReturn;
    }

    private TimotharBaronOfBatsReturnEffect(TimotharBaronOfBatsReturnEffect effect) {
        super((OneShotEffect)effect);
        this.morOfCardToReturn = effect.morOfCardToReturn;
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = this.morOfCardToReturn.getCard(game);
        if (card == null) {
            return false;
        }
        return player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null);
    }

    public TimotharBaronOfBatsReturnEffect copy() {
        return new TimotharBaronOfBatsReturnEffect(this);
    }
}

