/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class TinybonesBaubleBurglarExileEffect
extends OneShotEffect {
    TinybonesBaubleBurglarExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it from their graveyard with a stash counter on it";
    }

    private TinybonesBaubleBurglarExileEffect(TinybonesBaubleBurglarExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public TinybonesBaubleBurglarExileEffect copy() {
        return new TinybonesBaubleBurglarExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = (Card)this.getValue("discardedCard");
        if (player == null || card == null || !Zone.GRAVEYARD.match(game.getState().getZone(card.getId()))) {
            return false;
        }
        player.moveCardsToExile(card, source, game, true, null, "");
        card.addCounters(CounterType.STASH.createInstance(), source, game);
        return true;
    }
}

