/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.CardState;
import mage.game.Game;
import mage.players.ManaPoolItem;

class TinybonesBaubleBurglarSpendAnyManaEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    TinybonesBaubleBurglarSpendAnyManaEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = ", and mana of any type can be spent to cast those spells";
    }

    private TinybonesBaubleBurglarSpendAnyManaEffect(TinybonesBaubleBurglarSpendAnyManaEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public TinybonesBaubleBurglarSpendAnyManaEffect copy() {
        return new TinybonesBaubleBurglarSpendAnyManaEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId) || !game.getOpponents(game.getOwnerId(sourceId)).contains(source.getControllerId())) {
            return false;
        }
        Card card = game.getCard(sourceId);
        if (card == null) {
            return false;
        }
        card = card.getMainCard();
        if (game.getState().getZone(card.getId()) == Zone.EXILED) {
            return card.getCounters(game).getCount(CounterType.STASH) > 0;
        }
        CardState cardState = card instanceof SplitCard ? game.getLastKnownInformationCard(card.getId(), Zone.EXILED) : (card instanceof CardWithSpellOption ? game.getLastKnownInformationCard(card.getId(), Zone.EXILED) : (card instanceof ModalDoubleFacedCard ? game.getLastKnownInformationCard(((ModalDoubleFacedCard)card).getLeftHalfCard().getId(), Zone.EXILED) : game.getLastKnownInformationCard(card.getId(), Zone.EXILED)));
        return cardState != null && cardState.getCounters().getCount(CounterType.STASH) > 0;
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        if (mana.getSourceObject() != null) {
            return mana.getFirstAvailable();
        }
        return null;
    }
}

