/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class TipTheScalesEffect
extends OneShotEffect {
    TipTheScalesEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice a creature. When you do, all creatures get -X/-X until end of turn, where X is the sacrificed creature's toughness";
    }

    private TipTheScalesEffect(TipTheScalesEffect effect) {
        super((OneShotEffect)effect);
    }

    public TipTheScalesEffect copy() {
        return new TipTheScalesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        player.choose(Outcome.Sacrifice, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int value = permanent.getToughness().getValue();
        if (!permanent.sacrifice(source, game) || value < 1) {
            return false;
        }
        game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new BoostAllEffect(-value, -value, Duration.EndOfTurn), false), source);
        return true;
    }
}

