/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.condition.common.MyTurnCondition;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.AbilityType;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class TitheTakerCostReductionEffect
extends CostModificationEffectImpl {
    TitheTakerCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "During your turn, spells your opponents cast cost {1} more to cast and abilities your opponents activate cost {1} more to activate unless they're mana abilities.";
    }

    private TitheTakerCostReductionEffect(TitheTakerCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        if (abilityToModify.getAbilityType() == AbilityType.SPELL) {
            SpellAbility spellAbility = (SpellAbility)abilityToModify;
            CardUtil.adjustCost((SpellAbility)spellAbility, (int)-1);
        }
        if (abilityToModify.isNonManaActivatedAbility()) {
            CardUtil.increaseCost((Ability)abilityToModify, (int)1);
        }
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return MyTurnCondition.instance.apply(game, source) && (abilityToModify.getAbilityType() == AbilityType.SPELL || abilityToModify.isNonManaActivatedAbility()) && game.getOpponents(source.getControllerId()).contains(abilityToModify.getControllerId());
    }

    public TitheTakerCostReductionEffect copy() {
        return new TitheTakerCostReductionEffect(this);
    }
}

