/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.InvestigateEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;

class TivitSellerOfSecretsEffect
extends OneShotEffect {
    TivitSellerOfSecretsEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for evidence or bribery. For each evidence vote, investigate. For each bribery vote, create a Treasure token";
    }

    private TivitSellerOfSecretsEffect(TivitSellerOfSecretsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TivitSellerOfSecretsEffect copy() {
        return new TivitSellerOfSecretsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TwoChoiceVote vote = new TwoChoiceVote("Evidence (investigate)", "Bribery (treasure)", Outcome.Detriment);
        vote.doVotes(source, game);
        int evidenceCounter = vote.getVoteCount((Object)true);
        int briberyCounter = vote.getVoteCount((Object)false);
        if (evidenceCounter > 0) {
            new InvestigateEffect(evidenceCounter).apply(game, source);
        }
        if (briberyCounter > 0) {
            new TreasureToken().putOntoBattlefield(briberyCounter, game, source);
        }
        return evidenceCounter + briberyCounter > 0;
    }
}

