/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.t.TlincalliHunterAlternativeCost;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TlincalliHunterAddAltCostEffect
extends ContinuousEffectImpl {
    TlincalliHunterAddAltCostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Once each turn, you may pay {0} rather than pay the mana cost for a creature spell you cast from exile.";
    }

    private TlincalliHunterAddAltCostEffect(TlincalliHunterAddAltCostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TlincalliHunterAddAltCostEffect copy() {
        return new TlincalliHunterAddAltCostEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent sourcePermanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (sourcePermanent = game.getPermanent(source.getSourceId())) != null) {
            Boolean wasItUsed = (Boolean)game.getState().getValue(sourcePermanent.getId().toString() + sourcePermanent.getZoneChangeCounter(game) + sourcePermanent.getTurnsOnBattlefield());
            if (wasItUsed == null) {
                TlincalliHunterAlternativeCost alternateCostAbility = new TlincalliHunterAlternativeCost();
                alternateCostAbility.setSourceId(source.getSourceId());
                controller.getAlternativeSourceCosts().add(alternateCostAbility);
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

