/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class TobiasDoomedConquerorWatcher
extends Watcher {
    private final Map<UUID, Integer> playerMap = new HashMap<UUID, Integer>();

    TobiasDoomedConquerorWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent() || zEvent.getTarget() == null || !zEvent.getTarget().isCreature(game) || zEvent.getTarget() instanceof PermanentToken) {
            return;
        }
        this.playerMap.compute(zEvent.getTarget().getControllerId(), CardUtil::setOrIncrementValue);
    }

    public void reset() {
        super.reset();
        this.playerMap.clear();
    }

    static int getCount(Ability source, Game game) {
        return ((TobiasDoomedConquerorWatcher)game.getState().getWatcher(TobiasDoomedConquerorWatcher.class)).playerMap.getOrDefault(source.getControllerId(), 0);
    }
}

