/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlashbackAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.players.Player;

class TombfireEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("cards with flashback");

    public TombfireEffect() {
        super(Outcome.Exile);
        this.staticText = "Target player exiles all cards with flashback from their graveyard";
    }

    private TombfireEffect(TombfireEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            for (Card card : targetPlayer.getGraveyard().getCards(filter, game)) {
                card.moveToExile(null, "", source, game);
            }
            return true;
        }
        return false;
    }

    public TombfireEffect copy() {
        return new TombfireEffect(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(FlashbackAbility.class));
    }
}

