/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TophTheFirstMetalbenderEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterControlledArtifactPermanent();

    TophTheFirstMetalbenderEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "nontoken artifacts you control are lands in addition to their other types";
        this.dependendToTypes.add(DependencyType.ArtifactAddingRemoving);
        this.dependencyTypes.add(DependencyType.BecomeNonbasicLand);
    }

    private TophTheFirstMetalbenderEffect(TophTheFirstMetalbenderEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TophTheFirstMetalbenderEffect copy() {
        return new TophTheFirstMetalbenderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            permanent.addCardType(game, new CardType[]{CardType.LAND});
        }
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

