/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ToralfsHammerEffect
extends OneShotEffect {
    ToralfsHammerEffect() {
        super(Outcome.Benefit);
    }

    private ToralfsHammerEffect(ToralfsHammerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ToralfsHammerEffect copy() {
        return new ToralfsHammerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Object object = this.getValue("attachedPermanent");
        Player player = game.getPlayer(source.getControllerId());
        if (!(object instanceof Permanent) || player == null) {
            return false;
        }
        Permanent permanent = (Permanent)object;
        Permanent targetedPermanent = game.getPermanent(source.getFirstTarget());
        if (targetedPermanent == null) {
            Player targetedPlayer = game.getPlayer(source.getFirstTarget());
            if (targetedPlayer != null) {
                targetedPlayer.damage(3, permanent.getId(), source, game);
            }
        } else {
            targetedPermanent.damage(3, permanent.getId(), source, game);
        }
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        return true;
    }

    public String getText(Mode mode) {
        String name = "Toralf's Hammer";
        Object object = this.getValue("attachedPermanent");
        if (object instanceof Permanent) {
            name = ((Permanent)object).getName();
        }
        return "It deals 3 damage to any target. Return " + name + " to its owner's hand.";
    }
}

