/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.InvestigateEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class TorchTheWitnessEffect
extends OneShotEffect {
    TorchTheWitnessEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals twice X damage to target creature. If excess damage was dealt to that creature this way, investigate";
    }

    private TorchTheWitnessEffect(TorchTheWitnessEffect effect) {
        super((OneShotEffect)effect);
    }

    public TorchTheWitnessEffect copy() {
        return new TorchTheWitnessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (permanent.damageWithExcess(2 * (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0), source, game) > 0) {
            InvestigateEffect.doInvestigate((UUID)source.getControllerId(), (int)1, (Game)game, (Ability)source);
        }
        return true;
    }
}

