/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class TorrentOfSoulsEffect
extends OneShotEffect {
    TorrentOfSoulsEffect() {
        super(Outcome.BoostCreature);
    }

    private TorrentOfSoulsEffect(TorrentOfSoulsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TorrentOfSoulsEffect copy() {
        return new TorrentOfSoulsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetedPlayer = game.getPlayer(((Target)source.getTargets().get(1)).getFirstTarget());
        if (targetedPlayer != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ControllerIdPredicate(targetedPlayer.getId()));
            BoostAllEffect boostEffect = new BoostAllEffect(2, 0, Duration.EndOfTurn, filter, true);
            GainAbilityAllEffect gainAbilityEffect = new GainAbilityAllEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filter);
            game.addEffect((ContinuousEffect)boostEffect, source);
            game.addEffect((ContinuousEffect)gainAbilityEffect, source);
            return true;
        }
        return false;
    }
}

