/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.AttackedOrBlockedThisCombatWatcher;

class TotalWarDestroyEffect
extends OneShotEffect {
    TotalWarDestroyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all untapped non-Wall creatures that player controls that didn't attack, except for creatures the player hasn't controlled continuously since the beginning of the turn";
    }

    private TotalWarDestroyEffect(TotalWarDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TotalWarDestroyEffect copy() {
        return new TotalWarDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player activePlayer = game.getPlayer(game.getActivePlayerId());
        if (activePlayer == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(activePlayer.getId())) {
            AttackedOrBlockedThisCombatWatcher watcher;
            if (!permanent.isCreature(game) || permanent.isTapped() || permanent.hasSubtype(SubType.WALL, game) || (watcher = (AttackedOrBlockedThisCombatWatcher)game.getState().getWatcher(AttackedOrBlockedThisCombatWatcher.class)) != null && watcher.getAttackedThisTurnCreatures().contains(new MageObjectReference((MageObject)permanent, game)) || !permanent.wasControlledFromStartOfControllerTurn()) continue;
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

