/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TovolarDireOverlordEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("Human Werewolves you control");

    TovolarDireOverlordEffect() {
        super(Outcome.Benefit);
        this.staticText = "it becomes night. Then transform any number of Human Werewolves you control";
    }

    private TovolarDireOverlordEffect(TovolarDireOverlordEffect effect) {
        super((OneShotEffect)effect);
    }

    public TovolarDireOverlordEffect copy() {
        return new TovolarDireOverlordEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        game.setDaytime(false);
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return true;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        for (UUID permanentId : target.getTargets()) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            permanent.transform(source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.HUMAN.getPredicate());
        filter.add((Predicate)SubType.WEREWOLF.getPredicate());
    }
}

