/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ToxrillTheCorrosiveEffect
extends ContinuousEffectImpl {
    ToxrillTheCorrosiveEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.UnboostCreature);
        this.staticText = "creatures you don't control get -1/-1 for each slime counter on them";
    }

    private ToxrillTheCorrosiveEffect(ToxrillTheCorrosiveEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ToxrillTheCorrosiveEffect copy() {
        return new ToxrillTheCorrosiveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL, source.getControllerId(), source, game)) {
            int counter = permanent.getCounters(game).getCount(CounterType.SLIME);
            permanent.getPower().increaseBoostedValue(-counter);
            permanent.getToughness().increaseBoostedValue(-counter);
        }
        return true;
    }
}

