/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.common.FilterPlaneswalkerPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TragicArroganceEffect
extends OneShotEffect {
    TragicArroganceEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each player, you choose from among the permanents that player controls an artifact, a creature, an enchantment, and a planeswalker. Then each player sacrifices all other nonland permanents they control";
    }

    private TragicArroganceEffect(TragicArroganceEffect effect) {
        super((OneShotEffect)effect);
    }

    public TragicArroganceEffect copy() {
        return new TragicArroganceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            HashSet<Permanent> chosenPermanents = new HashSet<Permanent>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                FilterArtifactPermanent filterArtifactPermanent = new FilterArtifactPermanent("an artifact of " + player.getName());
                filterArtifactPermanent.add((Predicate)new ControllerIdPredicate(playerId));
                TargetPermanent target1 = new TargetPermanent(1, 1, (FilterPermanent)filterArtifactPermanent, true);
                FilterCreaturePermanent filterCreaturePermanent = new FilterCreaturePermanent("a creature of " + player.getName());
                filterCreaturePermanent.add((Predicate)new ControllerIdPredicate(playerId));
                TargetPermanent target2 = new TargetPermanent(1, 1, (FilterPermanent)filterCreaturePermanent, true);
                FilterEnchantmentPermanent filterEnchantmentPermanent = new FilterEnchantmentPermanent("an enchantment of " + player.getName());
                filterEnchantmentPermanent.add((Predicate)new ControllerIdPredicate(playerId));
                TargetPermanent target3 = new TargetPermanent(1, 1, (FilterPermanent)filterEnchantmentPermanent, true);
                FilterPlaneswalkerPermanent filterPlaneswalkerPermanent = new FilterPlaneswalkerPermanent("a planeswalker of " + player.getName());
                filterPlaneswalkerPermanent.add((Predicate)new ControllerIdPredicate(playerId));
                TargetPermanent target4 = new TargetPermanent(1, 1, (FilterPermanent)filterPlaneswalkerPermanent, true);
                if (target1.canChoose(controller.getId(), source, game)) {
                    controller.chooseTarget(Outcome.Benefit, (Target)target1, source, game);
                    Permanent artifact = game.getPermanent(target1.getFirstTarget());
                    if (artifact != null) {
                        chosenPermanents.add(artifact);
                    }
                    target1.clearChosen();
                }
                if (target2.canChoose(controller.getId(), source, game)) {
                    controller.chooseTarget(Outcome.Benefit, (Target)target2, source, game);
                    Permanent creature = game.getPermanent(target2.getFirstTarget());
                    if (creature != null) {
                        chosenPermanents.add(creature);
                    }
                    target2.clearChosen();
                }
                if (target3.canChoose(controller.getId(), source, game)) {
                    controller.chooseTarget(Outcome.Benefit, (Target)target3, source, game);
                    Permanent enchantment = game.getPermanent(target3.getFirstTarget());
                    if (enchantment != null) {
                        chosenPermanents.add(enchantment);
                    }
                    target3.clearChosen();
                }
                if (!target4.canChoose(controller.getId(), source, game)) continue;
                controller.chooseTarget(Outcome.Benefit, (Target)target4, source, game);
                Permanent planeswalker = game.getPermanent(target4.getFirstTarget());
                if (planeswalker != null) {
                    chosenPermanents.add(planeswalker);
                }
                target4.clearChosen();
            }
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENTS_NON_LAND, playerId, game)) {
                    if (chosenPermanents.contains(permanent)) continue;
                    permanent.sacrifice(source, game);
                }
            }
            return true;
        }
        return false;
    }
}

