/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class TranceKujaFateDefiedEffect
extends ReplacementEffectImpl {
    TranceKujaFateDefiedEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a Wizard you control would deal damage to a permanent or player, it deals double that damage instead.";
    }

    private TranceKujaFateDefiedEffect(TranceKujaFateDefiedEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public TranceKujaFateDefiedEffect copy() {
        return new TranceKujaFateDefiedEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType().equals((Object)GameEvent.EventType.DAMAGE_PLAYER) || event.getType().equals((Object)GameEvent.EventType.DAMAGE_PERMANENT);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getControllerId(event.getSourceId()).equals(source.getControllerId()) && Optional.ofNullable(game.getObject(event.getSourceId())).map(object -> object.hasSubtype(SubType.WIZARD, game)).orElse(false) != false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

