/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.choices.VoteHandler;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TrapTheTrespassersVote
extends VoteHandler<Permanent> {
    private final FilterPermanent filter;

    TrapTheTrespassersVote(Ability source, Game game) {
        this.filter = new FilterCreaturePermanent("creature not controlled by " + game.getPlayer(source.getControllerId()).getName());
        this.filter.add(Predicates.not((Predicate)new ControllerIdPredicate(source.getControllerId())));
        this.secret = true;
    }

    protected Set<Permanent> getPossibleVotes(Ability source, Game game) {
        return new HashSet<Permanent>();
    }

    protected Permanent playerChoose(String voteInfo, Player player, Player decidingPlayer, Ability source, Game game) {
        TargetPermanent target = new TargetPermanent(this.filter);
        target.withNotTarget(true);
        decidingPlayer.choose(Outcome.UnboostCreature, (Target)target, source, game);
        return game.getPermanent(target.getFirstTarget());
    }

    protected String voteName(Permanent vote) {
        return vote.getIdName();
    }

    Map<Permanent, Integer> getVotesPerCreature(Game game) {
        return this.playerMap.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(Function.identity(), x -> 1, Integer::sum));
    }
}

