/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class TravelingPlagueEffect
extends OneShotEffect {
    TravelingPlagueEffect() {
        super(Outcome.Detriment);
        this.staticText = "that creature's controller returns {this} from its owner's graveyard to the battlefield";
    }

    private TravelingPlagueEffect(TravelingPlagueEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantedCreature = (Permanent)game.getState().getValue("travelingPlague" + source.getSourceId());
        if (enchantedCreature != null) {
            Player controllerOfEnchantedCreature = game.getPlayer(enchantedCreature.getControllerId());
            Card travelingPlague = game.getCard(source.getSourceId());
            if (travelingPlague != null && game.getState().getZone(travelingPlague.getId()) == Zone.GRAVEYARD && controllerOfEnchantedCreature != null) {
                Permanent targetPermanent;
                TargetPermanent target = new TargetPermanent((FilterPermanent)new FilterCreaturePermanent("creature to enchant with " + travelingPlague.getName()));
                target.withNotTarget(true);
                if (controllerOfEnchantedCreature.choose(Outcome.Detriment, (Target)target, source, game) && !(targetPermanent = game.getPermanent(target.getFirstTarget())).cantBeAttachedBy((MageObject)travelingPlague, source, game, false)) {
                    game.getState().setValue("attachTo:" + travelingPlague.getId(), (Object)targetPermanent);
                    controllerOfEnchantedCreature.moveCards(travelingPlague, Zone.BATTLEFIELD, source, game);
                    return targetPermanent.addAttachment(travelingPlague.getId(), source, game);
                }
            }
        }
        return false;
    }

    public TravelingPlagueEffect copy() {
        return new TravelingPlagueEffect(this);
    }
}

