/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class TraverseTheOutlandsEffect
extends OneShotEffect {
    TraverseTheOutlandsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for up to X basic land cards, where X is the greatest power among creatures you control. Put those cards onto the battlefield tapped, then shuffle.";
    }

    private TraverseTheOutlandsEffect(TraverseTheOutlandsEffect effect) {
        super((OneShotEffect)effect);
    }

    public TraverseTheOutlandsEffect copy() {
        return new TraverseTheOutlandsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterLandPermanent filter = new FilterLandPermanent();
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        List creatures = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, controller.getId(), game);
        int amount = 0;
        for (Permanent creature : creatures) {
            int power = creature.getPower().getValue();
            if (amount >= power) continue;
            amount = power;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, amount, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        if (controller.searchLibrary(target, source, game)) {
            controller.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        controller.shuffleLibrary(source, game);
        return true;
    }
}

