/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TrazynTheInfiniteEffect
extends ContinuousEffectImpl {
    TrazynTheInfiniteEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "as long as {this} is on the battlefield, it has all activated abilities of all artifact cards in your graveyard";
        this.dependendToTypes.add(DependencyType.AddingAbility);
    }

    private TrazynTheInfiniteEffect(TrazynTheInfiniteEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Player player = game.getPlayer(source.getControllerId());
        if (permanent == null || player == null) {
            return false;
        }
        Set abilities = player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, game).stream().map(card -> card.getAbilities(game)).flatMap(Collection::stream).filter(Ability::isActivatedAbility).collect(Collectors.toSet());
        for (Ability ability : abilities) {
            permanent.addAbility(ability, source.getSourceId(), game, true);
        }
        return true;
    }

    public TrazynTheInfiniteEffect copy() {
        return new TrazynTheInfiniteEffect(this);
    }
}

