/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBaseToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TreeOfPerditionEffect
extends OneShotEffect {
    TreeOfPerditionEffect() {
        super(Outcome.Neutral);
        this.staticText = "Exchange target opponent's life total with {this}'s toughness";
    }

    private TreeOfPerditionEffect(TreeOfPerditionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm == null || opponent == null || !opponent.isLifeTotalCanChange() || !perm.isCreature(game)) {
            return false;
        }
        int amount = perm.getToughness().getValue();
        int life = opponent.getLife();
        if (life == amount) {
            return false;
        }
        if (life < amount && !opponent.isCanGainLife()) {
            return false;
        }
        if (life > amount && !opponent.isCanLoseLife()) {
            return false;
        }
        opponent.setLife(amount, game, source);
        game.addEffect((ContinuousEffect)new SetBaseToughnessSourceEffect(life, Duration.Custom), source);
        return true;
    }

    public TreeOfPerditionEffect copy() {
        return new TreeOfPerditionEffect(this);
    }
}

