/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.constants.PhaseStep;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TrenchBehemothEffect
extends RequirementEffect {
    TrenchBehemothEffect() {
        super(Duration.Custom);
        this.staticText = "target creature an opponent controls attacks during its controller's next combat phase if able";
    }

    private TrenchBehemothEffect(TrenchBehemothEffect effect) {
        super((RequirementEffect)effect);
    }

    public TrenchBehemothEffect copy() {
        return new TrenchBehemothEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return this.getTargetPointer().getFirst(game, source).equals(permanent.getId());
    }

    public boolean isInactive(Ability source, Game game) {
        if (game.getPermanent(this.getTargetPointer().getFirst(game, source)) == null) {
            return true;
        }
        return game.isActivePlayer(game.getControllerId(this.getTargetPointer().getFirst(game, source))) && game.getTurnPhaseType() == TurnPhase.COMBAT && game.getTurnStepType() == PhaseStep.END_COMBAT;
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }
}

