/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class TrevaTheRenewerEffect
extends OneShotEffect {
    TrevaTheRenewerEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a color, then you gain 1 life for each permanent of that color.";
    }

    private TrevaTheRenewerEffect(TrevaTheRenewerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrevaTheRenewerEffect copy() {
        return new TrevaTheRenewerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ChoiceColor choice = new ChoiceColor();
        if (controller.choose(this.outcome, (Choice)choice, game)) {
            game.informPlayers(controller.getLogName() + " chooses " + choice.getColor());
            FilterPermanent filter = new FilterPermanent();
            filter.add((Predicate)new ColorPredicate(choice.getColor()));
            int cardsWithColor = game.getBattlefield().count(filter, controller.getId(), source, game);
            if (cardsWithColor > 0) {
                new GainLifeEffect(cardsWithColor).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

