/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class TrialOfATimeLordEffect
extends OneShotEffect {
    TrialOfATimeLordEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for innocent or guilty. If guilty gets more votes, the owner of each card exiled with {this} puts that card on the bottom of their library";
    }

    private TrialOfATimeLordEffect(TrialOfATimeLordEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrialOfATimeLordEffect copy() {
        return new TrialOfATimeLordEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TwoChoiceVote vote = new TwoChoiceVote("Innocent", "Guilty", Outcome.Detriment);
        vote.doVotes(source, game);
        if (vote.getMostVoted().contains(Boolean.TRUE)) {
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (player != null && exileZone != null && !exileZone.isEmpty()) {
            player.putCardsOnBottomOfLibrary((Cards)exileZone, game, source, false);
        }
        return true;
    }
}

