/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBlockTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.RandomUtil;

class TrialOfAgonyEffect
extends OneShotEffect {
    TrialOfAgonyEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose two target creatures controlled by the same opponent. That player chooses one of those creatures. {this} deals 5 damage to that creature, and the other can't block this turn";
    }

    private TrialOfAgonyEffect(TrialOfAgonyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrialOfAgonyEffect copy() {
        return new TrialOfAgonyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent cantBlock;
        Permanent toDamage;
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        switch (permanents.size()) {
            case 0: {
                return false;
            }
            case 1: {
                toDamage = (Permanent)permanents.get(0);
                cantBlock = null;
                break;
            }
            default: {
                Player player = game.getPlayer(((Permanent)permanents.get(0)).getControllerId());
                if (player == null) {
                    toDamage = (Permanent)permanents.get(0);
                    cantBlock = (Permanent)permanents.get(1);
                    break;
                }
                FilterPermanent filter = new FilterPermanent();
                filter.add(Predicates.or((Iterable)permanents.stream().map(MageItem::getId).map(ControllerIdPredicate::new).collect(Collectors.toList())));
                TargetPermanent target = new TargetPermanent(filter);
                target.withChooseHint("to deal damage to");
                target.withNotTarget(true);
                player.choose(this.outcome, (Target)target, source, game);
                toDamage = game.getPermanent(target.getFirstTarget());
                permanents.remove(toDamage);
                cantBlock = (Permanent)RandomUtil.randomFromCollection(permanents);
            }
        }
        if (toDamage != null) {
            toDamage.damage(5, source, game);
        }
        if (cantBlock != null) {
            game.addEffect(new CantBlockTargetEffect(Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(cantBlock, game)), source);
        }
        return true;
    }
}

