/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.SaprolingToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class TribuneOfRotEffect
extends OneShotEffect {
    private static final Token token = new SaprolingToken();

    TribuneOfRotEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "mill two cards. For each creature card milled this way, create a 1/1 green Saproling creature token";
    }

    private TribuneOfRotEffect(TribuneOfRotEffect effect) {
        super((OneShotEffect)effect);
    }

    public TribuneOfRotEffect copy() {
        return new TribuneOfRotEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int numOfCreatureCardsMilled = player.millCards(2, source, game).count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
            if (numOfCreatureCardsMilled > 0) {
                game.processAction();
                token.putOntoBattlefield(numOfCreatureCardsMilled, game, source, source.getControllerId(), false, false);
            }
            return true;
        }
        return false;
    }
}

