/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TributeToTheWorldTreeEffect
extends OneShotEffect {
    TributeToTheWorldTreeEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card if its power is 3 or greater. Otherwise, put two +1/+1 counters on it";
    }

    private TributeToTheWorldTreeEffect(TributeToTheWorldTreeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TributeToTheWorldTreeEffect copy() {
        return new TributeToTheWorldTreeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanentEntering = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (permanentEntering == null) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(permanentEntering.getId());
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        if (power < 3) {
            return permanent.addCounters(CounterType.P1P1.createInstance(2), source, game);
        }
        Player player = game.getPlayer(source.getControllerId());
        return player != null && player.drawCards(1, source, game) > 0;
    }
}

