/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.t.TrickbindCantActivateEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TrickbindCounterEffect
extends OneShotEffect {
    TrickbindCounterEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target activated or triggered ability. If a permanent's ability is countered this way, activated abilities of that permanent can't be activated this turn";
    }

    private TrickbindCounterEffect(TrickbindCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrickbindCounterEffect copy() {
        return new TrickbindCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(source.getFirstTarget());
        if (stackObject != null && game.getStack().counter(source.getFirstTarget(), source, game)) {
            TrickbindCantActivateEffect effect = new TrickbindCantActivateEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(stackObject.getSourceId()));
            game.getContinuousEffects().addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

