/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class TrinisphereEffect
extends CostModificationEffectImpl {
    TrinisphereEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral, CostModificationType.SET_COST);
        this.staticText = "As long as {this} is untapped, each spell that would cost less than three mana to cast costs three mana to cast";
    }

    protected TrinisphereEffect(TrinisphereEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int manaCost = abilityToModify.getManaCostsToPay().manaValue();
        if (manaCost < 3) {
            CardUtil.increaseCost((Ability)abilityToModify, (int)(3 - manaCost));
        }
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify instanceof SpellAbility) {
            Permanent permanent = game.getPermanent(source.getSourceId());
            return permanent != null && !permanent.isTapped();
        }
        return false;
    }

    public TrinisphereEffect copy() {
        return new TrinisphereEffect(this);
    }
}

