/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TroveWardenEffect
extends OneShotEffect {
    TroveWardenEffect() {
        super(Outcome.Benefit);
        this.staticText = "put each permanent card exiled with it onto the battlefield under the control of that card's owner";
    }

    private TroveWardenEffect(TroveWardenEffect effect) {
        super((OneShotEffect)effect);
    }

    public TroveWardenEffect copy() {
        return new TroveWardenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = (Permanent)this.getValue("permanentLeftBattlefield");
        if (controller == null || permanent == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)permanent.getId(), (int)permanent.getZoneChangeCounter(game)));
        if (exileZone == null) {
            return true;
        }
        return controller.moveCards(exileZone.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
    }
}

