/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class TruthOrTaleEffect
extends OneShotEffect {
    TruthOrTaleEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Reveal the top five cards of your library and separate them into two piles. An opponent chooses one of those piles. Put a card from the chosen pile into your hand, then put all other cards revealed this way on the bottom of your library in any order";
    }

    private TruthOrTaleEffect(TruthOrTaleEffect effect) {
        super((OneShotEffect)effect);
    }

    public TruthOrTaleEffect copy() {
        return new TruthOrTaleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetOpponent target;
        Player opponent;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 5));
        controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
        Set opponents = game.getOpponents(controller.getId());
        if (opponents.size() == 1) {
            opponent = game.getPlayer((UUID)opponents.iterator().next());
        } else {
            target = new TargetOpponent(true);
            controller.chooseTarget(Outcome.Detriment, (Target)target, source, game);
            opponent = game.getPlayer(target.getFirstTarget());
        }
        if (opponent != null) {
            Card finalChosenCard;
            TargetCard finalChosenCardTarget;
            CardsImpl chosenCards;
            ArrayList<Card> chosen;
            Card card;
            target = new TargetCard(0, cards.size(), Zone.LIBRARY, new FilterCard("cards to put in the first pile"));
            ArrayList<Card> pile1 = new ArrayList<Card>();
            if (controller.choose(Outcome.Neutral, (Cards)cards, (TargetCard)target, source, game)) {
                List targets = target.getTargets();
                for (UUID targetId : targets) {
                    card = game.getCard(targetId);
                    if (card == null) continue;
                    pile1.add(card);
                }
            }
            ArrayList<Card> pile2 = new ArrayList<Card>();
            for (UUID cardId : cards) {
                card = game.getCard(cardId);
                if (card == null || pile1.contains(card)) continue;
                pile2.add(card);
            }
            boolean choice = opponent.choosePile(Outcome.Detriment, "Choose a pile for " + controller.getName() + " to choose a card from.", pile1, pile2, game);
            ArrayList<Card> arrayList = chosen = choice ? pile1 : pile2;
            if (!chosen.isEmpty() && controller.choose(Outcome.DrawCard, (Cards)(chosenCards = new CardsImpl(new HashSet(chosen))), finalChosenCardTarget = new TargetCard(Zone.LIBRARY, new FilterCard("card to put into your hand")), source, game) && (finalChosenCard = game.getCard(finalChosenCardTarget.getFirstTarget())) != null) {
                if (!game.isSimulation()) {
                    game.informPlayers(controller.getLogName() + " chose to put " + finalChosenCard.getIdName() + " into their hand.");
                }
                cards.remove(finalChosenCard);
                controller.moveCards(finalChosenCard, Zone.HAND, source, game);
            }
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
        }
        return true;
    }
}

