/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class TunnelVisionEffect
extends OneShotEffect {
    TunnelVisionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player reveals cards from the top of their library until a card with that name is revealed. If it is, that player puts the rest of the revealed cards into their graveyard and puts the card with the chosen name on top of their library. Otherwise, the player shuffles";
    }

    private TunnelVisionEffect(TunnelVisionEffect effect) {
        super((OneShotEffect)effect);
    }

    public TunnelVisionEffect copy() {
        return new TunnelVisionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (targetPlayer == null || cardName == null || cardName.isEmpty()) {
            return false;
        }
        CardsImpl cardsToReveal = new CardsImpl();
        Card namedCard = null;
        for (Card card : targetPlayer.getLibrary().getCards(game)) {
            cardsToReveal.add(card);
            if (!CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
            namedCard = card;
            break;
        }
        targetPlayer.revealCards(source, (Cards)cardsToReveal, game);
        if (namedCard != null) {
            cardsToReveal.remove(namedCard);
            targetPlayer.moveCards((Cards)cardsToReveal, Zone.GRAVEYARD, source, game);
            targetPlayer.putCardsOnTopOfLibrary((Cards)new CardsImpl(namedCard), game, source, true);
        } else {
            targetPlayer.shuffleLibrary(source, game);
        }
        return true;
    }
}

