/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.cards.t.TurfWarPredicate;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TurfWarControlEffect
extends OneShotEffect {
    TurfWarControlEffect() {
        super(Outcome.GainControl);
        this.staticText = "that creature's controller gains control of one of those lands of their choice and untaps it";
    }

    private TurfWarControlEffect(TurfWarControlEffect effect) {
        super((OneShotEffect)effect);
    }

    public TurfWarControlEffect copy() {
        return new TurfWarControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanentOrLKIBattlefield(this.getUUIDValue("creature"));
        if (creature == null) {
            return false;
        }
        Player creatureController = game.getPlayer(creature.getControllerId());
        if (creatureController == null) {
            return false;
        }
        Player damagedPlayer = game.getPlayer(this.getUUIDValue("player"));
        if (damagedPlayer == null) {
            return false;
        }
        FilterLandPermanent filter = new FilterLandPermanent("land with a contested counter controlled by " + damagedPlayer.getName());
        filter.add((Predicate)new ControllerIdPredicate(damagedPlayer.getId()));
        filter.add((Predicate)TurfWarPredicate.instance);
        TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
        if (!target.canChoose(creatureController.getId(), source, game)) {
            return false;
        }
        creatureController.chooseTarget(Outcome.GainControl, (Target)target, source, game);
        Permanent land = game.getPermanent(target.getFirstTarget());
        if (land == null) {
            return false;
        }
        GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, creatureController.getId());
        effect.setTargetPointer((TargetPointer)new FixedTarget(land, game));
        game.addEffect((ContinuousEffect)effect, source);
        land.untap(game);
        return true;
    }

    private UUID getUUIDValue(String key) {
        Object value = this.getValue(key);
        if (!(value instanceof UUID)) {
            return null;
        }
        return (UUID)value;
    }
}

