/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.target.Target;

class TurnTheTablesEffect
extends RedirectionEffect {
    TurnTheTablesEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, RedirectionEffect.UsageType.ACCORDING_DURATION);
        this.staticText = "All combat damage that would be dealt to you this turn is dealt to target attacking creature instead";
    }

    private TurnTheTablesEffect(TurnTheTablesEffect effect) {
        super((RedirectionEffect)effect);
    }

    public TurnTheTablesEffect copy() {
        return new TurnTheTablesEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.getPlayer(source.getControllerId()) == null || game.getPermanent(source.getFirstTarget()) == null) {
            return false;
        }
        DamageEvent damageEvent = (DamageEvent)event;
        if (!damageEvent.isCombatDamage() || !source.getControllerId().equals(damageEvent.getTargetId())) {
            return false;
        }
        this.redirectTarget = (Target)source.getTargets().get(0);
        return true;
    }
}

