/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TurnaboutEffect
extends OneShotEffect {
    private static final Set<String> choice = new HashSet<String>();

    public TurnaboutEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose artifact, creature, or land. Tap all untapped permanents of the chosen type target player controls, or untap all tapped permanents of that type that player controls";
    }

    private TurnaboutEffect(TurnaboutEffect effect) {
        super((OneShotEffect)effect);
    }

    public TurnaboutEffect copy() {
        return new TurnaboutEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterControlledPermanent filter;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || game.getPlayer(source.getFirstTarget()) == null) {
            return true;
        }
        ChoiceImpl choiceImpl = new ChoiceImpl(true);
        choiceImpl.setMessage("Choose card type to tap or untap");
        choiceImpl.setChoices(choice);
        if (!controller.choose(Outcome.Neutral, (Choice)choiceImpl, game)) {
            return false;
        }
        switch (choiceImpl.getChoice()) {
            case "Artifact": {
                filter = StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT;
                break;
            }
            case "Land": {
                filter = StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND;
                break;
            }
            case "Creature": {
                filter = StaticFilters.FILTER_CONTROLLED_CREATURE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Choice is required");
            }
        }
        boolean tap = controller.chooseUse(Outcome.Neutral, "Tap or untap?", null, "Tap", "Untap", source, game);
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getFirstTarget(), source, game)) {
            if (tap) {
                permanent.tap(source, game);
                continue;
            }
            permanent.untap(game);
        }
        return true;
    }

    static {
        choice.add(CardType.ARTIFACT.toString());
        choice.add(CardType.CREATURE.toString());
        choice.add(CardType.LAND.toString());
    }
}

